/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;

class BigInteger {
    private static final int[][] a = new int[][]{{3, 5, 7, 11, 13, 17, 19, 23}, {29, 31, 37, 41, 43}, {47, 53, 59, 61, 67}, {71, 73, 79, 83}, {89, 97, 101, 103}, {107, 109, 113, 127}, {131, 137, 139, 149}, {151, 157, 163, 167}, {173, 179, 181, 191}, {193, 197, 199, 211}, {223, 227, 229}, {233, 239, 241}, {251, 257, 263}, {269, 271, 277}, {281, 283, 293}, {307, 311, 313}, {317, 331, 337}, {347, 349, 353}, {359, 367, 373}, {379, 383, 389}, {397, 401, 409}, {419, 421, 431}, {433, 439, 443}, {449, 457, 461}, {463, 467, 479}, {487, 491, 499}, {503, 509, 521}, {523, 541, 547}, {557, 563, 569}, {571, 577, 587}, {593, 599, 601}, {607, 613, 617}, {619, 631, 641}, {643, 647, 653}, {659, 661, 673}, {677, 683, 691}, {701, 709, 719}, {727, 733, 739}, {743, 751, 757}, {761, 769, 773}, {787, 797, 809}, {811, 821, 823}, {827, 829, 839}, {853, 857, 859}, {863, 877, 881}, {883, 887, 907}, {911, 919, 929}, {937, 941, 947}, {953, 967, 971}, {977, 983, 991}, {997, 1009, 1013}, {1019, 1021, 1031}};
    private static int[] b;
    private static final int[] c;
    public static final BigInteger ZERO;
    public static final BigInteger ONE;
    private static final BigInteger d;
    private int e;
    private int[] f;
    private int g = -1;
    private int h = -1;
    private long i = -1L;
    private static final byte[] j;

    private BigInteger() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private BigInteger(int n, int[] nArray) {
        if (nArray.length <= 0) {
            this.f = nArray;
            this.e = 0;
            return;
        }
        this.e = n;
        for (n = 0; n < nArray.length && nArray[n] == 0; ++n) {
        }
        if (n == 0) {
            this.f = nArray;
            return;
        }
        int[] nArray2 = new int[nArray.length - n];
        System.arraycopy(nArray, n, nArray2, 0, nArray2.length);
        this.f = nArray2;
        if (nArray2.length != 0) return;
        this.e = 0;
    }

    public BigInteger(String string) {
        this(string, 10);
    }

    public BigInteger(String string, int n) {
        if (string.length() == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        if (n < 2 || n > 36) {
            throw new NumberFormatException("Radix out of range");
        }
        int n2 = 0;
        this.e = 1;
        if (string.charAt(0) == '-') {
            if (string.length() == 1) {
                throw new NumberFormatException("Zero length BigInteger");
            }
            this.e = -1;
            n2 = 1;
        }
        while (n2 < string.length() && Character.digit(string.charAt(n2), n) == 0) {
            ++n2;
        }
        if (n2 >= string.length()) {
            this.e = 0;
            this.f = new int[0];
            return;
        }
        BigInteger bigInteger = ZERO;
        BigInteger bigInteger2 = BigInteger.valueOf(n);
        while (n2 < string.length()) {
            bigInteger = bigInteger.multiply(bigInteger2).add(BigInteger.valueOf(Character.digit(string.charAt(n2), n)));
            ++n2;
        }
        this.f = bigInteger.f;
    }

    public BigInteger(byte[] byArray) {
        if (byArray.length == 0) {
            throw new NumberFormatException("Zero length BigInteger");
        }
        this.e = 1;
        if (byArray[0] < 0) {
            this.e = -1;
        }
        this.f = this.a(byArray, this.e);
        if (this.f.length == 0) {
            this.e = 0;
        }
    }

    private int[] a(byte[] objectArray, int n) {
        int n2;
        if (n >= 0) {
            int n3;
            for (n3 = 0; n3 < objectArray.length && objectArray[n3] == 0; ++n3) {
            }
            if (n3 >= objectArray.length) {
                return new int[0];
            }
            int n4 = (objectArray.length - n3 + 3) / 4;
            int n5 = (objectArray.length - n3) % 4;
            if (n5 == 0) {
                n5 = 4;
            }
            int[] nArray = new int[n4];
            int n6 = 0;
            int n7 = 0;
            for (n = n3; n < objectArray.length; ++n) {
                n6 <<= 8;
                n6 |= objectArray[n] & 0xFF;
                if (--n5 > 0) continue;
                nArray[n7] = n6;
                ++n7;
                n5 = 4;
                n6 = 0;
            }
            return nArray;
        }
        for (n2 = 0; n2 < objectArray.length - 1 && objectArray[n2] == 255; ++n2) {
        }
        int n8 = objectArray.length;
        boolean bl = false;
        if (objectArray[n2] == 128) {
            for (n = n2 + 1; n < objectArray.length && objectArray[n] == 0; ++n) {
            }
            if (n == objectArray.length) {
                ++n8;
                bl = true;
            }
        }
        int n9 = (n8 - n2 + 3) / 4;
        int n10 = (n8 - n2) % 4;
        if (n10 == 0) {
            n10 = 4;
        }
        Object[] objectArray2 = new int[n9];
        n9 = 0;
        int n11 = 0;
        if (bl && --n10 <= 0) {
            ++n11;
            n10 = 4;
        }
        for (n = n2; n < objectArray.length; ++n) {
            n9 <<= 8;
            n9 |= ~objectArray[n] & 0xFF;
            if (--n10 > 0) continue;
            objectArray2[n11] = n9;
            ++n11;
            n10 = 4;
            n9 = 0;
        }
        objectArray = objectArray2;
        n = objectArray2.length - 1;
        long l = ((long)objectArray[n] & 0xFFFFFFFFL) + 1L;
        objectArray[n--] = (int)l;
        l >>>= 32;
        while (n >= 0 && l != 0L) {
            objectArray[n--] = (int)(l += (long)objectArray[n] & 0xFFFFFFFFL);
            l >>>= 32;
        }
        objectArray2 = objectArray;
        if (objectArray[0] == 0) {
            objectArray = new int[objectArray2.length - 1];
            System.arraycopy(objectArray2, 1, objectArray, 0, objectArray.length);
            objectArray2 = objectArray;
        }
        return objectArray2;
    }

    public BigInteger(int n, byte[] byArray) {
        if (n < -1 || n > 1) {
            throw new NumberFormatException("Invalid sign value");
        }
        if (n == 0) {
            this.e = 0;
            this.f = new int[0];
            return;
        }
        this.f = this.a(byArray, 1);
        this.e = n;
    }

    public BigInteger abs() {
        if (this.e >= 0) {
            return this;
        }
        return this.negate();
    }

    private static int[] a(int[] nArray, int[] nArray2) {
        int n = nArray.length - 1;
        int n2 = nArray2.length - 1;
        long l = 0L;
        while (n2 >= 0) {
            nArray[n--] = (int)(l += ((long)nArray[n] & 0xFFFFFFFFL) + ((long)nArray2[n2--] & 0xFFFFFFFFL));
            l >>>= 32;
        }
        while (n >= 0 && l != 0L) {
            nArray[n--] = (int)(l += (long)nArray[n] & 0xFFFFFFFFL);
            l >>>= 32;
        }
        return nArray;
    }

    public BigInteger add(BigInteger bigInteger) {
        int[] nArray;
        if (bigInteger.e == 0 || bigInteger.f.length == 0) {
            return this;
        }
        if (this.e == 0 || this.f.length == 0) {
            return bigInteger;
        }
        if (bigInteger.e < 0) {
            if (this.e > 0) {
                return this.subtract(bigInteger.negate());
            }
        } else if (this.e < 0) {
            return bigInteger.subtract(this.negate());
        }
        int[] nArray2 = bigInteger.f;
        bigInteger = this;
        if (bigInteger.f.length < nArray2.length) {
            nArray = nArray2;
            nArray2 = bigInteger.f;
        } else {
            nArray = bigInteger.f;
        }
        int n = Integer.MAX_VALUE;
        if (nArray.length == nArray2.length) {
            n = Integer.MAX_VALUE - nArray2[0];
        }
        n = (nArray[0] ^ Integer.MIN_VALUE) >= n ? 1 : 0;
        n = n != 0 ? 1 : 0;
        int[] nArray3 = new int[nArray.length + n];
        System.arraycopy(nArray, 0, nArray3, n, nArray.length);
        nArray3 = BigInteger.a(nArray3, nArray2);
        return new BigInteger(bigInteger.e, nArray3);
    }

    public BigInteger and(BigInteger bigInteger) {
        if (this.e == 0 || bigInteger.e == 0) {
            return ZERO;
        }
        int[] nArray = this.e > 0 ? this.f : this.add((BigInteger)BigInteger.ONE).f;
        int[] nArray2 = bigInteger.e > 0 ? bigInteger.f : bigInteger.add((BigInteger)BigInteger.ONE).f;
        boolean bl = this.e < 0 && bigInteger.e < 0;
        int n = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n];
        int n2 = nArray3.length - nArray.length;
        int n3 = nArray3.length - nArray2.length;
        for (int i = 0; i < nArray3.length; ++i) {
            int n4;
            int n5 = i >= n2 ? nArray[i - n2] : 0;
            int n6 = n4 = i >= n3 ? nArray2[i - n3] : 0;
            if (this.e < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            if (bigInteger.e < 0) {
                n4 ^= 0xFFFFFFFF;
            }
            nArray3[i] = n5 & n4;
            if (!bl) continue;
            nArray3[i] = ~nArray3[i];
        }
        BigInteger bigInteger2 = new BigInteger(1, nArray3);
        if (bl) {
            bigInteger2 = bigInteger2.not();
        }
        return bigInteger2;
    }

    public BigInteger andNot(BigInteger bigInteger) {
        return this.and(bigInteger.not());
    }

    public int bitCount() {
        if (this.g == -1) {
            if (this.e < 0) {
                this.g = this.not().bitCount();
            } else {
                int n = 0;
                for (int i = 0; i < this.f.length; ++i) {
                    n += j[this.f[i] & 0xFF];
                    n += j[this.f[i] >> 8 & 0xFF];
                    n += j[this.f[i] >> 16 & 0xFF];
                    n += j[this.f[i] >>> 24];
                }
                this.g = n;
            }
        }
        return this.g;
    }

    private int a(int n, int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        while (n != nArray.length && nArray[n] == 0) {
            ++n;
        }
        if (n == nArray.length) {
            return 0;
        }
        int n2 = 32 * (nArray.length - n - 1);
        n2 += BigInteger.bitLen(nArray[n]);
        if (this.e < 0) {
            boolean bl = j[nArray[n] & 0xFF] + j[nArray[n] >> 8 & 0xFF] + j[nArray[n] >> 16 & 0xFF] + j[nArray[n] >>> 24] == 1;
            ++n;
            while (n < nArray.length && bl) {
                bl = nArray[n] == 0;
                ++n;
            }
            n2 -= bl ? 1 : 0;
        }
        return n2;
    }

    public int bitLength() {
        if (this.h == -1) {
            this.h = this.e == 0 ? 0 : this.a(0, this.f);
        }
        return this.h;
    }

    static int bitLen(int n) {
        if (n < 32768) {
            if (n < 128) {
                if (n < 8) {
                    if (n < 2) {
                        if (n <= 0) {
                            if (n < 0) {
                                return 32;
                            }
                            return 0;
                        }
                        return 1;
                    }
                    if (n < 4) {
                        return 2;
                    }
                    return 3;
                }
                if (n < 32) {
                    if (n < 16) {
                        return 4;
                    }
                    return 5;
                }
                if (n < 64) {
                    return 6;
                }
                return 7;
            }
            if (n < 2048) {
                if (n < 512) {
                    if (n < 256) {
                        return 8;
                    }
                    return 9;
                }
                if (n < 1024) {
                    return 10;
                }
                return 11;
            }
            if (n < 8192) {
                if (n < 4096) {
                    return 12;
                }
                return 13;
            }
            if (n < 16384) {
                return 14;
            }
            return 15;
        }
        if (n < 0x800000) {
            if (n < 524288) {
                if (n < 131072) {
                    if (n < 65536) {
                        return 16;
                    }
                    return 17;
                }
                if (n < 262144) {
                    return 18;
                }
                return 19;
            }
            if (n < 0x200000) {
                if (n < 0x100000) {
                    return 20;
                }
                return 21;
            }
            if (n < 0x400000) {
                return 22;
            }
            return 23;
        }
        if (n < 0x8000000) {
            if (n < 0x2000000) {
                if (n < 0x1000000) {
                    return 24;
                }
                return 25;
            }
            if (n < 0x4000000) {
                return 26;
            }
            return 27;
        }
        if (n < 0x20000000) {
            if (n < 0x10000000) {
                return 28;
            }
            return 29;
        }
        if (n < 0x40000000) {
            return 30;
        }
        return 31;
    }

    public int compareTo(Object object) {
        return this.compareTo((BigInteger)object);
    }

    private int a(int n, int[] nArray, int n2, int[] nArray2) {
        while (n != nArray.length && nArray[n] == 0) {
            ++n;
        }
        while (n2 != nArray2.length && nArray2[n2] == 0) {
            ++n2;
        }
        return BigInteger.b(n, nArray, n2, nArray2);
    }

    private static int b(int n, int[] nArray, int n2, int[] nArray2) {
        int n3 = nArray.length - nArray2.length - (n - n2);
        if (n3 != 0) {
            if (n3 < 0) {
                return -1;
            }
            return 1;
        }
        while (n < nArray.length) {
            int n4;
            if ((n3 = nArray[n++]) == (n4 = nArray2[n2++])) continue;
            if ((n3 ^ Integer.MIN_VALUE) < (n4 ^ Integer.MIN_VALUE)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int compareTo(BigInteger bigInteger) {
        if (this.e < bigInteger.e) {
            return -1;
        }
        if (this.e > bigInteger.e) {
            return 1;
        }
        if (this.e == 0) {
            return 0;
        }
        return this.e * this.a(0, this.f, 0, bigInteger.f);
    }

    private int[] b(int[] nArray, int[] nArray2) {
        int[] nArray3;
        int n = this.a(0, nArray, 0, nArray2);
        if (n > 0) {
            int[] nArray4;
            int[] nArray5;
            n = this.a(0, nArray) - this.a(0, nArray2);
            if (n > 1) {
                nArray5 = BigInteger.a(nArray2, n - 1);
                nArray3 = BigInteger.a(BigInteger.ONE.f, n - 1);
                if (n % 32 == 0) {
                    nArray4 = new int[n / 32 + 1];
                    System.arraycopy(nArray3, 0, nArray4, 1, nArray4.length - 1);
                    nArray4[0] = 0;
                    nArray3 = nArray4;
                }
            } else {
                nArray5 = new int[nArray.length];
                nArray3 = new int[1];
                System.arraycopy(nArray2, 0, nArray5, nArray5.length - nArray2.length, nArray2.length);
                nArray3[0] = 1;
            }
            nArray4 = new int[nArray3.length];
            BigInteger.a(nArray, 0, nArray5);
            System.arraycopy(nArray3, 0, nArray4, 0, nArray3.length);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (true) {
                if ((n = this.a(n2, nArray, n3, nArray5)) >= 0) {
                    BigInteger.a(nArray, n3, nArray5);
                    BigInteger.a(nArray3, nArray4);
                    continue;
                }
                n = this.a(n2, nArray, 0, nArray2);
                if (n <= 0) break;
                if (nArray[n2] == 0) {
                    ++n2;
                }
                if ((n = this.a(n3, nArray5) - this.a(n2, nArray)) == 0) {
                    BigInteger.b(n3, nArray5);
                    BigInteger.b(n4, nArray4);
                } else {
                    BigInteger.a(n3, nArray5, n);
                    BigInteger.a(n4, nArray4, n);
                }
                if (nArray5[n3] == 0) {
                    ++n3;
                }
                if (nArray4[n4] != 0) continue;
                ++n4;
            }
            if (n == 0) {
                BigInteger.a(nArray3, BigInteger.ONE.f);
                for (int i = n2; i != nArray.length; ++i) {
                    nArray[i] = 0;
                }
            }
        } else if (n == 0) {
            int[] nArray6 = new int[1];
            nArray3 = nArray6;
            nArray6[0] = 1;
        } else {
            int[] nArray7 = new int[1];
            nArray3 = nArray7;
            nArray7[0] = 0;
        }
        return nArray3;
    }

    public BigInteger divide(BigInteger bigInteger) {
        if (bigInteger.e == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        if (this.e == 0) {
            return ZERO;
        }
        if (bigInteger.compareTo(ONE) == 0) {
            return this;
        }
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        return new BigInteger(this.e * bigInteger.e, this.b(nArray, bigInteger.f));
    }

    public BigInteger[] divideAndRemainder(BigInteger bigInteger) {
        if (bigInteger.e == 0) {
            throw new ArithmeticException("Divide by zero");
        }
        BigInteger[] bigIntegerArray = new BigInteger[2];
        if (this.e == 0) {
            bigIntegerArray[0] = bigIntegerArray[1] = ZERO;
            return bigIntegerArray;
        }
        if (bigInteger.compareTo(ONE) == 0) {
            bigIntegerArray[0] = this;
            bigIntegerArray[1] = ZERO;
            return bigIntegerArray;
        }
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        int[] nArray2 = this.b(nArray, bigInteger.f);
        bigIntegerArray[0] = new BigInteger(this.e * bigInteger.e, nArray2);
        bigIntegerArray[1] = new BigInteger(this.e, nArray);
        return bigIntegerArray;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BigInteger)) {
            return false;
        }
        object = (BigInteger)object;
        if (((BigInteger)object).e != this.e || ((BigInteger)object).f.length != this.f.length) {
            return false;
        }
        for (int i = 0; i < this.f.length; ++i) {
            if (((BigInteger)object).f[i] == this.f[i]) continue;
            return false;
        }
        return true;
    }

    public BigInteger gcd(BigInteger bigInteger) {
        if (bigInteger.e == 0) {
            return this.abs();
        }
        if (this.e == 0) {
            return bigInteger.abs();
        }
        BigInteger bigInteger2 = this;
        BigInteger bigInteger3 = bigInteger;
        while (bigInteger3.e != 0) {
            bigInteger = bigInteger2.mod(bigInteger3);
            bigInteger2 = bigInteger3;
            bigInteger3 = bigInteger;
        }
        return bigInteger2;
    }

    public int hashCode() {
        int n = this.f.length;
        if (this.f.length > 0) {
            n ^= this.f[0];
            if (this.f.length > 1) {
                n ^= this.f[this.f.length - 1];
            }
        }
        if (this.e < 0) {
            return ~n;
        }
        return n;
    }

    public int intValue() {
        if (this.f.length == 0) {
            return 0;
        }
        if (this.e < 0) {
            return -this.f[this.f.length - 1];
        }
        return this.f[this.f.length - 1];
    }

    public byte byteValue() {
        return (byte)this.intValue();
    }

    public long longValue() {
        if (this.f.length == 0) {
            return 0L;
        }
        long l = this.f.length > 1 ? (long)this.f[this.f.length - 2] << 32 | (long)this.f[this.f.length - 1] & 0xFFFFFFFFL : (long)this.f[this.f.length - 1] & 0xFFFFFFFFL;
        if (this.e < 0) {
            return -l;
        }
        return l;
    }

    public BigInteger max(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) > 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger min(BigInteger bigInteger) {
        if (this.compareTo(bigInteger) < 0) {
            return this;
        }
        return bigInteger;
    }

    public BigInteger mod(BigInteger bigInteger) {
        if (bigInteger.e <= 0) {
            throw new ArithmeticException("BigInteger: modulus is not positive");
        }
        BigInteger bigInteger2 = this.remainder(bigInteger);
        if (bigInteger2.e >= 0) {
            return bigInteger2;
        }
        return bigInteger2.add(bigInteger);
    }

    public BigInteger modInverse(BigInteger bigInteger) {
        if (bigInteger.e != 1) {
            throw new ArithmeticException("Modulus must be positive");
        }
        BigInteger bigInteger2 = new BigInteger();
        BigInteger bigInteger3 = BigInteger.a(this, bigInteger, bigInteger2, null);
        if (!bigInteger3.equals(ONE)) {
            throw new ArithmeticException("Numbers not relatively prime.");
        }
        if (bigInteger2.compareTo(ZERO) < 0) {
            bigInteger2 = bigInteger2.add(bigInteger);
        }
        return bigInteger2;
    }

    private static BigInteger a(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        bigInteger4 = ONE;
        BigInteger bigInteger5 = ZERO;
        while (bigInteger2.e > 0) {
            BigInteger[] bigIntegerArray = bigInteger.divideAndRemainder(bigInteger2);
            bigInteger = bigInteger4.subtract(bigInteger5.multiply(bigIntegerArray[0]));
            bigInteger4 = bigInteger5;
            bigInteger5 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigIntegerArray[1];
        }
        if (bigInteger3 != null) {
            bigInteger3.e = bigInteger4.e;
            bigInteger3.f = bigInteger4.f;
        }
        return bigInteger;
    }

    private static void a(int[] nArray) {
        for (int i = 0; i != nArray.length; ++i) {
            nArray[i] = 0;
        }
    }

    public BigInteger modPow(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3;
        Object object;
        if (bigInteger2.e <= 0) {
            throw new ArithmeticException("Modulus must be positive");
        }
        if (bigInteger2.equals(ONE)) {
            return ZERO;
        }
        if (bigInteger.e == 0) {
            return ONE;
        }
        if (this.e == 0) {
            return ZERO;
        }
        Object object2 = null;
        int[] nArray = null;
        boolean bl = (bigInteger2.f[bigInteger2.f.length - 1] & 1) == 1;
        long l = 0L;
        if (bl) {
            long l2;
            object2 = bigInteger2;
            if (((BigInteger)object2).i != -1L) {
                l2 = ((BigInteger)object2).i;
            } else if ((((BigInteger)object2).f[((BigInteger)object2).f.length - 1] & 1) == 0) {
                l2 = -1L;
            } else {
                long l3 = (long)(~((BigInteger)object2).f[((BigInteger)object2).f.length - 1] | 1) & 0xFFFFFFFFL;
                long l4 = 0x100000000L;
                long l5 = l3;
                object = object2;
                if (0x100000000L < 0L) {
                    throw new ArithmeticException("Modulus must be positive");
                }
                object = new long[2];
                long l6 = BigInteger.a(l5, 0x100000000L, (long[])object);
                if (l6 != 1L) {
                    throw new ArithmeticException("Numbers not relatively prime.");
                }
                if (object[0] < 0L) {
                    object[0] = object[0] + 0x100000000L;
                }
                l2 = ((BigInteger)object2).i = (long)object[0];
            }
            l = l2;
            bigInteger3 = this.shiftLeft(32 * bigInteger2.f.length).mod(bigInteger2);
            object2 = bigInteger3.f;
            bl = bigInteger3.f.length <= bigInteger2.f.length;
            if (bl) {
                nArray = new int[bigInteger2.f.length + 1];
                if (((Object)object2).length < bigInteger2.f.length) {
                    int[] nArray2 = new int[bigInteger2.f.length];
                    System.arraycopy(object2, 0, nArray2, nArray2.length - ((Object)object2).length, ((Object)object2).length);
                    object2 = nArray2;
                }
            }
        }
        if (!bl) {
            if (this.f.length <= bigInteger2.f.length) {
                object2 = new int[bigInteger2.f.length];
                System.arraycopy(this.f, 0, object2, ((Object)object2).length - this.f.length, this.f.length);
            } else {
                bigInteger3 = this.remainder(bigInteger2);
                object2 = new int[bigInteger2.f.length];
                System.arraycopy(bigInteger3.f, 0, object2, ((Object)object2).length - bigInteger3.f.length, bigInteger3.f.length);
            }
            nArray = new int[bigInteger2.f.length << 1];
        }
        object = new int[bigInteger2.f.length];
        for (int i = 0; i < bigInteger.f.length; ++i) {
            int n = bigInteger.f[i];
            int n2 = 0;
            if (i == 0) {
                while (n > 0) {
                    n <<= 1;
                    ++n2;
                }
                System.arraycopy(object2, 0, object, 0, ((Object)object2).length);
                n <<= 1;
                ++n2;
            }
            while (n != 0) {
                if (bl) {
                    this.a(nArray, (int[])object, (int[])object, bigInteger2.f, l);
                } else {
                    BigInteger.c(nArray, object);
                    this.d(nArray, bigInteger2.f);
                    System.arraycopy(nArray, nArray.length - ((int[])object).length, object, 0, ((int[])object).length);
                    BigInteger.a(nArray);
                }
                ++n2;
                if (n < 0) {
                    if (bl) {
                        this.a(nArray, (int[])object, (int[])object2, bigInteger2.f, l);
                    } else {
                        BigInteger.a(nArray, object, (int[])object2);
                        this.d(nArray, bigInteger2.f);
                        System.arraycopy(nArray, nArray.length - ((int[])object).length, object, 0, ((int[])object).length);
                        BigInteger.a(nArray);
                    }
                }
                n <<= 1;
            }
            while (n2 < 32) {
                if (bl) {
                    this.a(nArray, (int[])object, (int[])object, bigInteger2.f, l);
                } else {
                    BigInteger.c(nArray, object);
                    this.d(nArray, bigInteger2.f);
                    System.arraycopy(nArray, nArray.length - ((int[])object).length, object, 0, ((int[])object).length);
                    BigInteger.a(nArray);
                }
                ++n2;
            }
        }
        if (bl) {
            BigInteger.a((int[])object2);
            object2[((Object)object2).length - 1] = true;
            this.a(nArray, (int[])object, (int[])object2, bigInteger2.f, l);
        }
        BigInteger bigInteger4 = new BigInteger(1, (int[])object);
        if (bigInteger.e > 0) {
            return bigInteger4;
        }
        return bigInteger4.modInverse(bigInteger2);
    }

    private static int[] c(int[] nArray, int[] nArray2) {
        long l;
        long l2;
        int n = nArray.length - 1;
        for (int i = nArray2.length - 1; i != 0; --i) {
            long l3 = (long)nArray2[i] & 0xFFFFFFFFL;
            l2 = l3 * l3;
            l = l2 >>> 32;
            l2 &= 0xFFFFFFFFL;
            nArray[n] = (int)(l2 += (long)nArray[n] & 0xFFFFFFFFL);
            long l4 = l + (l2 >> 32);
            for (int j = i - 1; j >= 0; --j) {
                l2 = ((long)nArray2[j] & 0xFFFFFFFFL) * l3;
                l = l2 >>> 31;
                l2 = (l2 & Integer.MAX_VALUE) << 1;
                nArray[n] = (int)(l2 += ((long)nArray[--n] & 0xFFFFFFFFL) + l4);
                l4 = l + (l2 >>> 32);
            }
            nArray[n] = (int)(l4 += (long)nArray[--n] & 0xFFFFFFFFL);
            if (--n >= 0) {
                nArray[n] = (int)(l4 >> 32);
            }
            n += i;
        }
        l2 = (long)nArray2[0] & 0xFFFFFFFFL;
        l2 *= l2;
        l = l2 >>> 32;
        l2 &= 0xFFFFFFFFL;
        nArray[n] = (int)(l2 += (long)nArray[n] & 0xFFFFFFFFL);
        if (--n >= 0) {
            nArray[n] = (int)(l + (l2 >> 32) + (long)nArray[n]);
        }
        return nArray;
    }

    private static int[] a(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray3.length;
        if (n <= 0) {
            return nArray;
        }
        int n2 = nArray.length - nArray2.length;
        while (true) {
            long l = (long)nArray3[--n] & 0xFFFFFFFFL;
            long l2 = 0L;
            for (int i = nArray2.length - 1; i >= 0; --i) {
                nArray[n2 + i] = (int)(l2 += l * ((long)nArray2[i] & 0xFFFFFFFFL) + ((long)nArray[n2 + i] & 0xFFFFFFFFL));
                l2 >>>= 32;
            }
            --n2;
            if (n <= 0) {
                if (n2 < 0) break;
                nArray[n2] = (int)l2;
                break;
            }
            nArray[n2] = (int)l2;
        }
        return nArray;
    }

    private static long a(long l, long l2, long[] lArray) {
        long l3;
        long l4 = 1L;
        long l5 = l;
        long l6 = 0L;
        long l7 = l2;
        while (l7 > 0L) {
            long l8 = l5 / l7;
            long l9 = l4 - l6 * l8;
            l4 = l6;
            l6 = l9;
            l9 = l5 - l7 * l8;
            l5 = l7;
            l7 = l9;
        }
        lArray[0] = l4;
        lArray[1] = l3 = (l5 - l4 * l) / l2;
        return l5;
    }

    private void a(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, long l) {
        int n;
        int n2 = nArray4.length;
        int n3 = n2 - 1;
        long l2 = (long)nArray3[n3] & 0xFFFFFFFFL;
        for (n = 0; n <= n2; ++n) {
            nArray[n] = 0;
        }
        for (n = n2; n > 0; --n) {
            long l3 = (long)nArray2[n - 1] & 0xFFFFFFFFL;
            long l4 = (((long)nArray[n2] & 0xFFFFFFFFL) + (l3 * l2 & 0xFFFFFFFFL) & 0xFFFFFFFFL) * l & 0xFFFFFFFFL;
            long l5 = l3 * l2;
            long l6 = l4 * ((long)nArray4[n3] & 0xFFFFFFFFL);
            long l7 = ((long)nArray[n2] & 0xFFFFFFFFL) + (l5 & 0xFFFFFFFFL) + (l6 & 0xFFFFFFFFL);
            long l8 = (l5 >>> 32) + (l6 >>> 32) + (l7 >>> 32);
            for (int i = n3; i > 0; --i) {
                l5 = l3 * ((long)nArray3[i - 1] & 0xFFFFFFFFL);
                l6 = l4 * ((long)nArray4[i - 1] & 0xFFFFFFFFL);
                l7 = ((long)nArray[i] & 0xFFFFFFFFL) + (l5 & 0xFFFFFFFFL) + (l6 & 0xFFFFFFFFL) + (l8 & 0xFFFFFFFFL);
                l8 = (l8 >>> 32) + (l5 >>> 32) + (l6 >>> 32) + (l7 >>> 32);
                nArray[i + 1] = (int)l7;
            }
            nArray[1] = (int)(l8 += (long)nArray[0] & 0xFFFFFFFFL);
            nArray[0] = (int)(l8 >>> 32);
        }
        if (this.a(0, nArray, 0, nArray4) >= 0) {
            BigInteger.a(nArray, 0, nArray4);
        }
        System.arraycopy(nArray, 1, nArray2, 0, n2);
    }

    public BigInteger multiply(BigInteger bigInteger) {
        if (this.e == 0 || bigInteger.e == 0) {
            return ZERO;
        }
        int n = (this.bitLength() + bigInteger.bitLength()) / 32 + 1;
        int[] nArray = new int[n];
        if (bigInteger == this) {
            BigInteger.c(nArray, this.f);
        } else {
            BigInteger.a(nArray, this.f, bigInteger.f);
        }
        return new BigInteger(this.e * bigInteger.e, nArray);
    }

    public BigInteger negate() {
        if (this.e == 0) {
            return this;
        }
        return new BigInteger(-this.e, this.f);
    }

    public BigInteger not() {
        return this.add(ONE).negate();
    }

    public BigInteger pow(int n) {
        if (n < 0) {
            throw new ArithmeticException("Negative exponent");
        }
        if (this.e == 0) {
            if (n == 0) {
                return ONE;
            }
            return this;
        }
        BigInteger bigInteger = ONE;
        BigInteger bigInteger2 = this;
        while (n != 0) {
            if ((n & 1) == 1) {
                bigInteger = bigInteger.multiply(bigInteger2);
            }
            if ((n >>= 1) == 0) continue;
            bigInteger2 = bigInteger2.multiply(bigInteger2);
        }
        return bigInteger;
    }

    private int a(int n) {
        long l = 0L;
        for (int i = 0; i < this.f.length; ++i) {
            l = (l << 32 | (long)this.f[i] & 0xFFFFFFFFL) % (long)n;
        }
        return (int)l;
    }

    private int[] d(int[] nArray, int[] nArray2) {
        int n;
        int n2;
        for (n2 = 0; n2 < nArray.length && nArray[n2] == 0; ++n2) {
        }
        for (n = 0; n < nArray2.length && nArray2[n] == 0; ++n) {
        }
        int n3 = BigInteger.b(n2, nArray, n, nArray2);
        if (n3 > 0) {
            int[] nArray3;
            n3 = this.a(n, nArray2);
            int n4 = this.a(n2, nArray);
            int n5 = n4 - n3;
            int n6 = 0;
            int n7 = n3;
            if (n5 > 0) {
                nArray3 = BigInteger.a(nArray2, n5);
                n7 += n5;
            } else {
                n3 = nArray2.length - n;
                nArray3 = new int[n3];
                System.arraycopy(nArray2, n, nArray3, 0, n3);
            }
            block2: while (true) {
                if (n7 < n4 || BigInteger.b(n2, nArray, n6, nArray3) >= 0) {
                    BigInteger.a(nArray, n6, nArray3);
                    while (nArray[n2] == 0) {
                        if (++n2 != nArray.length) continue;
                        return nArray;
                    }
                    n3 = BigInteger.b(n2, nArray, n, nArray2);
                    if (n3 <= 0) break;
                    n4 = 32 * (nArray.length - n2 - 1) + BigInteger.bitLen(nArray[n2]);
                }
                if ((n5 = n7 - n4) < 2) {
                    BigInteger.b(n6, nArray3);
                    --n7;
                } else {
                    BigInteger.a(n6, nArray3, n5);
                    n7 -= n5;
                }
                while (true) {
                    if (nArray3[n6] != 0) continue block2;
                    ++n6;
                }
                break;
            }
        }
        if (n3 == 0) {
            for (n3 = n2; n3 < nArray.length; ++n3) {
                nArray[n3] = 0;
            }
        }
        return nArray;
    }

    public BigInteger remainder(BigInteger bigInteger) {
        int n;
        if (bigInteger.e == 0) {
            throw new ArithmeticException("BigInteger: Divide by zero");
        }
        if (this.e == 0) {
            return ZERO;
        }
        if (bigInteger.f.length == 1 && (n = bigInteger.f[0]) > 0) {
            if (n == 1) {
                return ZERO;
            }
            int n2 = this.a(n);
            if (n2 == 0) {
                return ZERO;
            }
            return new BigInteger(this.e, new int[]{n2});
        }
        if (this.a(0, this.f, 0, bigInteger.f) < 0) {
            return this;
        }
        Object object = bigInteger;
        if (((BigInteger)object).e > 0 && ((BigInteger)object).g == 1) {
            int[] nArray;
            int n3 = bigInteger.abs().bitLength() - 1;
            object = this;
            if (n3 <= 0) {
                nArray = c;
            } else {
                int n4 = (n3 + 31) / 32;
                n4 = Math.min(n4, ((BigInteger)object).f.length);
                int[] nArray2 = new int[n4];
                System.arraycopy(((BigInteger)object).f, ((BigInteger)object).f.length - n4, nArray2, 0, n4);
                if ((n3 %= 32) != 0) {
                    nArray2[0] = nArray2[0] & ~(-1 << n3);
                }
                nArray = nArray2;
            }
            object = nArray;
        } else {
            object = new int[this.f.length];
            System.arraycopy(this.f, 0, object, 0, ((Object)object).length);
            object = this.d((int[])object, bigInteger.f);
        }
        return new BigInteger(this.e, (int[])object);
    }

    private static int[] a(int[] nArray, int n) {
        int[] nArray2;
        int n2 = n >>> 5;
        int n3 = nArray.length;
        if ((n &= 0x1F) == 0) {
            nArray2 = new int[n3 + n2];
            System.arraycopy(nArray, 0, nArray2, 0, n3);
        } else {
            int n4 = 0;
            int n5 = 32 - n;
            int n6 = nArray[0] >>> n5;
            if (n6 != 0) {
                int[] nArray3 = new int[n3 + n2 + 1];
                nArray2 = nArray3;
                ++n4;
                nArray3[0] = n6;
            } else {
                nArray2 = new int[n3 + n2];
            }
            n6 = nArray[0];
            for (int i = 0; i < n3 - 1; ++i) {
                int n7 = nArray[i + 1];
                nArray2[n4++] = n6 << n | n7 >>> n5;
                n6 = n7;
            }
            nArray2[n4] = nArray[n3 - 1] << n;
        }
        return nArray2;
    }

    public BigInteger shiftLeft(int n) {
        if (this.e == 0 || this.f.length == 0) {
            return ZERO;
        }
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftRight(-n);
        }
        BigInteger bigInteger = new BigInteger(this.e, BigInteger.a(this.f, n));
        if (this.g != -1) {
            int n2 = bigInteger.g = this.e > 0 ? this.g : this.g + n;
        }
        if (this.h != -1) {
            bigInteger.h = this.h + n;
        }
        return bigInteger;
    }

    private static void a(int n, int[] nArray, int n2) {
        int n3;
        int n4;
        int n5 = (n2 >>> 5) + n;
        n2 &= 0x1F;
        int n6 = nArray.length - 1;
        if (n5 != n) {
            n4 = n5 - n;
            for (n3 = n6; n3 >= n5; --n3) {
                nArray[n3] = nArray[n3 - n4];
            }
            for (n3 = n5 - 1; n3 >= n; --n3) {
                nArray[n3] = 0;
            }
        }
        if (n2 != 0) {
            n4 = 32 - n2;
            n3 = nArray[n6];
            for (n = n6; n >= n5 + 1; --n) {
                n6 = nArray[n - 1];
                nArray[n] = n3 >>> n2 | n6 << n4;
                n3 = n6;
            }
            int n7 = n5;
            nArray[n7] = nArray[n7] >>> n2;
        }
    }

    private static void b(int n, int[] nArray) {
        int n2 = nArray.length - 1;
        int n3 = nArray[n2];
        while (n2 > n) {
            int n4 = nArray[n2 - 1];
            nArray[n2] = n3 >>> 1 | n4 << 31;
            n3 = n4;
            --n2;
        }
        int n5 = n;
        nArray[n5] = nArray[n5] >>> 1;
    }

    public BigInteger shiftRight(int n) {
        if (n == 0) {
            return this;
        }
        if (n < 0) {
            return this.shiftLeft(-n);
        }
        if (n >= this.bitLength()) {
            if (this.e < 0) {
                return BigInteger.valueOf(-1L);
            }
            return ZERO;
        }
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        BigInteger.a(0, nArray, n);
        return new BigInteger(this.e, nArray);
    }

    public int signum() {
        return this.e;
    }

    private static int[] a(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        int n4 = 0;
        do {
            long l = ((long)nArray[--n2] & 0xFFFFFFFFL) - ((long)nArray2[--n3] & 0xFFFFFFFFL) + (long)n4;
            nArray[n2] = (int)l;
            n4 = (int)(l >> 63);
        } while (n3 > n);
        if (n4 != 0) {
            int n5;
            do {
                n5 = --n2;
            } while ((nArray[n5] = nArray[n5] - 1) == -1);
        }
        return nArray;
    }

    public BigInteger subtract(BigInteger bigInteger) {
        BigInteger bigInteger2;
        if (bigInteger.e == 0 || bigInteger.f.length == 0) {
            return this;
        }
        if (this.e == 0 || this.f.length == 0) {
            return bigInteger.negate();
        }
        if (this.e != bigInteger.e) {
            return this.add(bigInteger.negate());
        }
        int n = this.a(0, this.f, 0, bigInteger.f);
        if (n == 0) {
            return ZERO;
        }
        if (n < 0) {
            bigInteger2 = bigInteger;
            bigInteger = this;
        } else {
            bigInteger2 = this;
        }
        int[] nArray = new int[bigInteger2.f.length];
        System.arraycopy(bigInteger2.f, 0, nArray, 0, nArray.length);
        return new BigInteger(this.e * n, BigInteger.a(nArray, 0, bigInteger.f));
    }

    public byte[] toByteArray() {
        if (this.e == 0) {
            return new byte[1];
        }
        int n = this.bitLength();
        byte[] byArray = new byte[n / 8 + 1];
        int n2 = this.f.length;
        int n3 = byArray.length;
        if (this.e > 0) {
            int n4;
            while (n2 > 1) {
                n4 = this.f[--n2];
                byArray[--n3] = (byte)n4;
                byArray[--n3] = (byte)(n4 >>> 8);
                byArray[--n3] = (byte)(n4 >>> 16);
                byArray[--n3] = n4 >> 24;
            }
            n4 = this.f[0];
            while ((n4 & 0xFFFFFF00) != 0) {
                byArray[--n3] = (byte)n4;
                n4 >>>= 8;
            }
            byArray[--n3] = (byte)n4;
        } else {
            int n5;
            boolean bl = true;
            while (n2 > 1) {
                n5 = ~this.f[--n2];
                if (bl) {
                    bl = ++n5 == 0;
                }
                byArray[--n3] = (byte)n5;
                byArray[--n3] = (byte)(n5 >>> 8);
                byArray[--n3] = (byte)(n5 >>> 16);
                byArray[--n3] = n5 >> 24;
            }
            n5 = this.f[0];
            if (bl) {
                --n5;
            }
            while ((n5 & 0xFFFFFF00) != 0) {
                byArray[--n3] = (byte)(~n5);
                n5 >>>= 8;
            }
            byArray[--n3] = (byte)(~n5);
            if (n3 > 0) {
                byArray[--n3] = -1;
            }
        }
        return byArray;
    }

    public BigInteger xor(BigInteger bigInteger) {
        if (this.e == 0) {
            return bigInteger;
        }
        if (bigInteger.e == 0) {
            return this;
        }
        int[] nArray = this.e > 0 ? this.f : this.add((BigInteger)BigInteger.ONE).f;
        int[] nArray2 = bigInteger.e > 0 ? bigInteger.f : bigInteger.add((BigInteger)BigInteger.ONE).f;
        boolean bl = this.e < 0 && bigInteger.e >= 0 || this.e >= 0 && bigInteger.e < 0;
        int n = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n];
        int n2 = nArray3.length - nArray.length;
        int n3 = nArray3.length - nArray2.length;
        for (int i = 0; i < nArray3.length; ++i) {
            int n4;
            int n5 = i >= n2 ? nArray[i - n2] : 0;
            int n6 = n4 = i >= n3 ? nArray2[i - n3] : 0;
            if (this.e < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            if (bigInteger.e < 0) {
                n4 ^= 0xFFFFFFFF;
            }
            nArray3[i] = n5 ^ n4;
            if (!bl) continue;
            nArray3[i] = ~nArray3[i];
        }
        BigInteger bigInteger2 = new BigInteger(1, nArray3);
        if (bl) {
            bigInteger2 = bigInteger2.not();
        }
        return bigInteger2;
    }

    public BigInteger or(BigInteger bigInteger) {
        if (this.e == 0) {
            return bigInteger;
        }
        if (bigInteger.e == 0) {
            return this;
        }
        int[] nArray = this.e > 0 ? this.f : this.add((BigInteger)BigInteger.ONE).f;
        int[] nArray2 = bigInteger.e > 0 ? bigInteger.f : bigInteger.add((BigInteger)BigInteger.ONE).f;
        boolean bl = this.e < 0 || bigInteger.e < 0;
        int n = Math.max(nArray.length, nArray2.length);
        int[] nArray3 = new int[n];
        int n2 = nArray3.length - nArray.length;
        int n3 = nArray3.length - nArray2.length;
        for (int i = 0; i < nArray3.length; ++i) {
            int n4;
            int n5 = i >= n2 ? nArray[i - n2] : 0;
            int n6 = n4 = i >= n3 ? nArray2[i - n3] : 0;
            if (this.e < 0) {
                n5 ^= 0xFFFFFFFF;
            }
            if (bigInteger.e < 0) {
                n4 ^= 0xFFFFFFFF;
            }
            nArray3[i] = n5 | n4;
            if (!bl) continue;
            nArray3[i] = ~nArray3[i];
        }
        BigInteger bigInteger2 = new BigInteger(1, nArray3);
        if (bl) {
            bigInteger2 = bigInteger2.not();
        }
        return bigInteger2;
    }

    public BigInteger setBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.testBit(n)) {
            return this;
        }
        if (this.e > 0 && n < this.bitLength() - 1) {
            return this.b(n);
        }
        return this.or(ONE.shiftLeft(n));
    }

    public BigInteger clearBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (!this.testBit(n)) {
            return this;
        }
        if (this.e > 0 && n < this.bitLength() - 1) {
            return this.b(n);
        }
        return this.andNot(ONE.shiftLeft(n));
    }

    public BigInteger flipBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Bit address less than zero");
        }
        if (this.e > 0 && n < this.bitLength() - 1) {
            return this.b(n);
        }
        return this.xor(ONE.shiftLeft(n));
    }

    private BigInteger b(int n) {
        int[] nArray = new int[this.f.length];
        System.arraycopy(this.f, 0, nArray, 0, nArray.length);
        int n2 = nArray.length - 1 - (n >>> 5);
        nArray[n2] = nArray[n2] ^ 1 << (n & 0x1F);
        return new BigInteger(this.e, nArray);
    }

    public String toString() {
        return this.toString(10);
    }

    public String toString(int n) {
        if (this.f == null) {
            return "null";
        }
        if (this.e == 0) {
            return "0";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (n == 16) {
            for (int i = 0; i < this.f.length; ++i) {
                String string = "0000000" + Integer.toHexString(this.f[i]);
                string = string.substring(string.length() - 8);
                stringBuffer.append(string);
            }
        } else if (n == 2) {
            stringBuffer.append('1');
            for (int i = this.bitLength() - 2; i >= 0; --i) {
                stringBuffer.append(this.testBit(i) ? (char)'1' : '0');
            }
        } else {
            Stack<String> stack = new Stack<String>();
            BigInteger bigInteger = new BigInteger(Integer.toString(n, n), n);
            BigInteger bigInteger2 = this.abs();
            while (!bigInteger2.equals(ZERO)) {
                BigInteger bigInteger3 = bigInteger2.mod(bigInteger);
                if (bigInteger3.equals(ZERO)) {
                    stack.push("0");
                } else {
                    stack.push(Integer.toString(bigInteger3.f[0], n));
                }
                bigInteger2 = bigInteger2.divide(bigInteger);
            }
            while (!stack.empty()) {
                stringBuffer.append((String)stack.pop());
            }
        }
        String string = stringBuffer.toString();
        while (string.length() > 1 && string.charAt(0) == '0') {
            string = string.substring(1);
        }
        if (string.length() == 0) {
            string = "0";
        } else if (this.e == -1) {
            string = "-" + string;
        }
        return string;
    }

    public static BigInteger valueOf(long l) {
        if (l == 0L) {
            return ZERO;
        }
        if (l < 0L) {
            if (l == Long.MIN_VALUE) {
                return BigInteger.valueOf(l ^ 0xFFFFFFFFFFFFFFFFL).not();
            }
            return BigInteger.valueOf(-l).negate();
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[7 - i] = (byte)l;
            l >>= 8;
        }
        return new BigInteger(byArray);
    }

    public int getLowestSetBit() {
        int n;
        if (this.e == 0) {
            return -1;
        }
        int n2 = this.f.length;
        while (--n2 > 0 && this.f[n2] == 0) {
        }
        int n3 = this.f[n2];
        int n4 = (n3 & 0xFFFF) == 0 ? ((n3 & 0xFF0000) == 0 ? 7 : 15) : (n = (n3 & 0xFF) == 0 ? 23 : 31);
        while (n > 0 && n3 << n != Integer.MIN_VALUE) {
            --n;
        }
        return (this.f.length - n2 << 5) - (n + 1);
    }

    public boolean testBit(int n) {
        if (n < 0) {
            throw new ArithmeticException("Bit position must not be negative");
        }
        if (this.e < 0) {
            return !this.not().testBit(n);
        }
        int n2 = n / 32;
        if (n2 >= this.f.length) {
            return false;
        }
        return ((n2 = this.f[this.f.length - 1 - n2]) >> n % 32 & 1) > 0;
    }

    static {
        c = new int[0];
        ZERO = new BigInteger(0, c);
        ONE = BigInteger.valueOf(1L);
        d = BigInteger.valueOf(2L);
        BigInteger.valueOf(3L);
        BigInteger.ZERO.g = 0;
        BigInteger.ZERO.h = 0;
        BigInteger.ONE.g = 1;
        BigInteger.ONE.h = 1;
        BigInteger.d.g = 1;
        BigInteger.d.h = 2;
        b = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            int[] nArray = a[i];
            int n = 1;
            for (int j = 0; j < nArray.length; ++j) {
                n *= nArray[j];
            }
            BigInteger.b[i] = n;
        }
        byte[] byArray = new byte[]{-1, 127, 63, 31, 15, 7, 3, 1};
        j = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    }
}

